/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8271k;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class AddrFilterCreate
implements JDMWizardPanelDelegate {
    private static String bundleName = "ibm.nways.jdm8271k.GeneralResources";
    private static ResourceBundle myResources = ResourceBundle.getBundle(bundleName);
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private static final int RASID = 19;
    private static final int RASSUB = 21;
    protected DestinationPropBook myBook;
    protected JdmBrowser browser;
    NavigationContext myContext;
    GenModel model;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.put("ibm8271eEsFilterStationAddress", new OctetString(""));
        hashtable.put("ibm8271eEsFilterAppliedPorts", new OctetString("00000000"));
        hashtable.put("ibm8271eEsFilterExitPorts", new OctetString("00000000"));
        hashtable.put("ibm8271eEsFilterType", new Integer(1));
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl;
        block12: {
            boolean bl2 = false;
            int n = 100;
            this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
            if (this.browser == null && this.myBook != null) {
                this.browser = (JdmBrowser)this.myBook.getBrowser();
            }
            bl = true;
            GenModel genModel = jDMWizardInfo.getModel();
            Hashtable hashtable = jDMWizardInfo.getItems();
            ModelInfo modelInfo = new ModelInfo();
            Vector vector = null;
            if (genModel != null) {
                try {
                    vector = genModel.getRestOfInfo("_Empty", "default", null, null);
                }
                catch (Exception exception) {
                    RAS.logError(19, 21, this, "proceed", "EXCEPTION_GETTING_MODELINFO", (Object)"_Empty", (Object)"Ibm8271eEsFilterModel");
                    RAS.logException(19, 21, this, "proceed", exception);
                }
            }
            if (vector.size() == n) {
                this.displayMsg(AddrFilterCreate.getNLSString("ADDRFLT_tableFull"));
                if (RAS.isEnabled(19, 21)) {
                    RAS.trace(19, 21, this, "proceed", "Address Filter table is full");
                }
                if (this.browser != null) {
                    MessageBox messageBox = new MessageBox(this.browser.getFrame(), AddrFilterCreate.getNLSString("TRP_error"), AddrFilterCreate.getNLSString("ADDRFLT_tableFull"), true);
                }
                return false;
            }
            modelInfo.add("Index.Ibm8271eEsFilterSwitchNumber", new Integer(1));
            modelInfo.add("Index.Ibm8271eEsFilterType", (Serializable)hashtable.get("ibm8271eEsFilterType"));
            modelInfo.add("Index.Ibm8271eEsFilterStationAddress", (Serializable)hashtable.get("ibm8271eEsFilterStationAddress"));
            modelInfo.add("Panel.Ibm8271eEsFilterAppliedPorts", (Serializable)hashtable.get("ibm8271eEsFilterAppliedPorts"));
            modelInfo.add("Panel.Ibm8271eEsFilterExitPorts", (Serializable)hashtable.get("ibm8271eEsFilterExitPorts"));
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                Enumeration enumeration = modelInfo.getItemIds();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Serializable serializable = modelInfo.get(string);
                    if (!(serializable instanceof SpecialValue)) continue;
                    bl2 = true;
                    bl = false;
                }
                if (!bl2) break block12;
                this.displayMsg(AddrFilterCreate.getNLSString("TRP_createError"));
                if (RAS.isEnabled(19, 21)) {
                    RAS.trace(19, 21, this, "proceed", "Address Filter Table create row error");
                }
                if (this.browser != null) {
                    MessageBox messageBox = new MessageBox(this.browser.getFrame(), AddrFilterCreate.getNLSString("TRP_error"), AddrFilterCreate.getNLSString("TRP_createError"), true);
                }
            }
            catch (Exception exception) {
                bl = false;
                RAS.logException(19, 21, this, "proceed", exception);
            }
        }
        return bl;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = commonResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
            }
        }
        return string2;
    }
}

